UserInterface.SetMissionText("Cellular Automaton Forest Generation Version 2")

--FUNCTIONS

function initialiseMap()
	for  x = 0, width - 1 do
		map[x] = {}
		for  y = 0, height - 1 do
			map[x][y] = 1
		end
	end
end

function randomFillMap()
	for x = 0, width - 1 do
		for y = 0, width - 1 do
			if(Utils.RandomInteger(0,100) > randomFillPercent)then
				map[x][y] = 0
			end
		end
	end	
end

function smoothMap()
	for x = 1, width - 2 do
		for y = 1, height - 2 do
			local areaWeight = parseTileArea(x, y)
			if(areaWeight > 4)then
				map[x][y] = 1
			elseif(areaWeight < 4)then
				map[x][y] = 0
			end
			
			if(map[x][y] == 1)then
				createVisual(x,y)
			end
		end
	end
end
	
function parseTileArea(x, y)
	local areaWeight = 0
	for tileX = x - 1, x + 1 do
		for tileY = y - 1, y + 1 do
			if((tileX ~= x) or (tileY ~= y))then
				areaWeight = areaWeight + map[tileX][tileY]
			end
		end
	end
	return areaWeight
end

function createVisual(x, y)
	local treeActor = Actor.Create("t" .. tostring(Utils.RandomInteger(10,14)), true, { Location = CPos.New(x ,y), Owner = Neutral })
end


--DECLARATIONS

Neutral = Player.GetPlayer("Neutral")
width = 130
height = 130
randomFillPercent = 46
map = {}

--CODE

initialiseMap()
Trigger.AfterDelay(0.1, randomFillMap)
Trigger.AfterDelay(0.1, smoothMap)