UserInterface.SetMissionText("Cellular Automaton Forest Generation Version 1")

--FUNCTIONS

function initialiseMap()
	
	local x = 0
	local y = 0
	
	while(x < width)do
		map[x] = {}
		while(y < height)do
			map[x][y] = 1
			y = y + 1
		end
		x = x + 1
		y = 0
	end
end

function randomFillMap()
	
	if(useRandomSeed)then
		seed = 1000
	end
	
	local x = 0
	local y = 0
	
	while(x < width)do
		while(y < height)do
			local rand = Utils.RandomInteger(0,100)
			if((x == 0) or (y == 0) or (x == width - 1) or (y == height - 1))then
				map[x][y] = 1
			else
				if(rand > randomFillPercent)then
					map[x][y] = 0
				else
					map[x][y] = 1
				end
			end
			y = y + 1
		end
		x = x + 1
		y = 0
	end	
end

function smoothMap()

	local x = 1
	local y = 1
	local areaWeight = 0
	
	while(x < width - 1)do
		while(y < height - 1)do
			areaWeight = parseTileArea(x, y)
			if(areaWeight > 4)then
				map[x][y] = 1
			elseif(areaWeight < 4)then
				map[x][y] = 0
			end
			y = y + 1
		end
		x = x + 1
		y = 1
	end
end
	
function parseTileArea(x, y)

	local tileX = x - 1
	local tileY = y - 1
	local areaWeight = 0
	
	while(tileX <= x + 1)do
		while(tileY <= y + 1)do
			if((tileX ~= x) or (tileY ~= y))then
				areaWeight = areaWeight + map[tileX][tileY]
			end
			tileY = tileY + 1
		end
		tileX = tileX + 1
		tileY = y - 1
	end
	
	return areaWeight
end

function generateMap()

	local x = 0
	local y = 0
	
	while(x < width)do
		while(y < height)do
			if(map[x][y] == 1)then
				createVisual(x,y)
			end
			y = y + 1
		end
		x = x + 1
		y = 0
	end
end

function createVisual(x, y)
	local testActor = Actor.Create("t" .. tostring(Utils.RandomInteger(10,14)), true, { Location = CPos.New(x + 1,y + 1), Owner = Neutral })
end


--DECLARATIONS

Neutral = Player.GetPlayer("Neutral")

width = 64
height = 64

seed = ""
useRandomSeed = true

randomFillPercent = 45

map = {}

--CODE

print("Code:")
initialiseMap()
randomFillMap()
smoothMap()
generateMap()